require 'rspec'
require 'watir-webdriver'
require 'page-object'

require 'common'
require 'login'
require 'loginLogout'
require 'base'
require 'accessVarUtility'
require 'accessAssessmentBuilder'
require 'DriverUtility'
require 'DBUtility'
require 'rspec_helper'
require 'vaToolSet/disclaimer'
require 'vaToolSet/launchpad'
require 'vaToolSet/home'
require 'vaToolSet/landing'
require 'vaToolSet/userMenu'

class VaToolSet_PageObject
  include PageObject

  def initialize(driver)
    @driver = driver
  end

  def common
    Common.new(@driver)
  end

  def login
    Login.new(@driver)
  end

  def loginLogout
    LoginLogout.new(@driver)
  end

  def base
    Base.new(@driver)
  end

  def accessVarUtility
    AccessVarUtility.new(@driver)
  end

  def accessAssessmentBuilder
  AccessAssessmentBuilder.new(@driver)
  end

  def home
    Home.new(@driver)
  end

  def disclaimer
    Disclaimer.new(@driver)
  end

  def landing
    Landing.new(@driver)
  end

  def launchpad
    Launchpad.new(@driver)
  end

  def userMenu
    UserMenu.new(@driver)
  end

end

